#!/bin/sh

MMC_CARD="mmcblk0"            # Name of SD/MMC card
DRIVE_LABEL="ELITE"
DATAFS_TYPE="ext4 -O ^has_journal"
EXTFS_TYPE="vfat -n "$DRIVE_LABEL
DATA_PART=$MMC_CARD"p5"

umount /mnt/mmcData
umount /mnt/data

echo "Creating partitions..."
# Hand over to fdisk for this bit
fdisk /dev/$MMC_CARD <<EOF
d
2
d
3
d
4
n
p
1

+6M
n
p
2

+6M
n
p
3

+210M
n
e


n

+875M
n


d
1
t
2
53
t
3
83
t
5
83
t
6
b
p
w
EOF

echo "Formatting $DATA_PART with file system type $DATAFS_TYPE"
echo ""
mkfs.$DATAFS_TYPE /dev/$DATA_PART
echo ""
DATA_PART=$MMC_CARD"p6"
echo "Formatting $DATA_PART with file system type $EXTFS_TYPE"
echo ""
mkfs.$EXTFS_TYPE /dev/$DATA_PART
echo ""

mount -a


